function B = subsref(A,S)

switch(S.type)
    case '()'
        if numel(S.subs) ~= 2, error('subsetting SimilarityMatrix requires two arguments'),end
        if ~(ischar(S.subs{1}) && ischar(S.subs{2}))
            throw(MException('SimilarityMatrix:Subsetting','SimilarityMatrix object must be subsetted using neuron names, or '':'''));
        end
        
        
        rowIdx = strcmp(A.Slabels,S.subs{1});
        
        if ~any(rowIdx)
            throw(MException('SimilarityMatrix:Subsetting',['Could not find cell ''' S.subs{1} '''']));
        end
        
        
        columnIdx = strcmp(A.Slabels,S.subs{2});
        if ~any(columnIdx)
            throw(MException('SimilarityMatrix:Subsetting',['Could not find cell ''' S.subs{2} '''']));
        end
        
        
        B = full(A.S(rowIdx,columnIdx));
        
        
    case '.'
        switch(S.subs)
            
        end
    otherwise
        error('SimilarityMatrix:SubSetting','Operation not recognized');
end

end

